-- Spirit Settings - Basic Script
-- Copyright (C) 2021 Spirit System, FrSky dev@spirit-system.com
-- This file is distributed under Creative Commons 4 license - BY-NC-ND
-- Script version: 3.7.0

local BUTTON = 2
local MENU = 3
local LABEL = 20

local FA_INVIS = 1
local FA_BANK =  2

local edit = false
local page = 1
local current = 1
local refreshState = 0
local refreshIndex = 0
local pageOffset = 0
local pages = {}
local fields = {}
local modifications = {}
local selectCtr = 0

local generalFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"Deska cykliky:", 1, 0, 5, nil, { "CCPM 120", "CCPM 120 rev", "CCPM 135", "CCPM 135 rev", "CCPM 140", "CCPM 140 rev", "CCPM 90", "CCPM 90 Velos", "Tandem" }, { 65, 66, 67, 68, 69, 70, 71, 72, 73} },
  {"Pozice:", 1, 0, 2, nil, { "Horz(0)", "Horz(180)", "Horz(0+i)", "Horz(180+i)", "Vert(0-l)", "Vert(180-l)", "Vert(0-r)", "Vert(180-r)" }, { 65, 66, 67, 68, 69, 70, 71, 72} },
  {"Prijimac:", 1, 0, 4, nil, { "PWM", "PPM", "S-BUS", "FPort" }, { 65, 66, 68, 72 } },
  { nil, 10, 0 },
  {"Letovy projev:", 0, FA_BANK, 44, nil, 1, 8, "", 1},
}

local servosFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"CYKLIKA", LABEL, 0 },
  {"Frekvence serv:", 1, 0, 7, nil, { "50Hz", "60Hz", "100Hz", "150Hz", "200Hz", "333Hz" }, { 65, 66, 67, 68, 69, 70 } },
  { nil, 10, 0 },
  {"VRTULKA", LABEL, 0 },
  {"Stred:", 1, 0, 8, nil, { "1520us", "960us", "760us" }, { 65, 66, 67 } },
  {"Frekvence serv:", 1, 0, 9, nil, { "50Hz", "60Hz", "100Hz", "150Hz", "200Hz", "333Hz", "560Hz", "700Hz" }, { 65, 66, 67, 68, 69, 70, 71, 72 } },
  { nil, 10, 0 },
  {"SUBTRIM", LABEL, 0 },
  {"CH1:", 0, 0, 15, nil, -127, 127, "", -128},
  {"CH2:", 0, 0, 16, nil, -127, 127, "", -128},
  {"CH3:", 0, 0, 17, nil, -127, 127, "", -128},
  {"CH4:", 0, 0, 11, nil, -127, 127, "", -128},
  { nil, 10, 0 },
  {"REVERZ SERV", LABEL, 0 },
  {"CH1: ", 1, 0, 21, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH2: ", 1, 0, 22, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH3: ", 1, 0, 23, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH4: ", 1, 0, 31, nil, { "[ ]", "[x]" }, { 48, 49 } },
}

local limitsFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"CYCLIC RING", LABEL, 0 },
  {"Rozsah Kridelka/Vyskovka:", 0, 0, 10, nil, 32, 255},
  { nil, 10, 0 },
  {"KOLEKTIV", LABEL, FA_BANK },
  {"Rozsah nabehu:", 0, FA_BANK, 12, nil, 32, 255},
  { nil, 10, 0 },
  {"LIMITY VRTULKY", LABEL, 0 },
  {"Pravy limit:", 0, 0, 14, nil, 32, 255},
  {"Levy limit:", 0, 0, 13, nil, 32, 255},
}

local sensorFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"", 0, FA_INVIS, 56, nil, 0, 7},
  {"CITLIVOST", LABEL, FA_BANK },
  {"Zisk cykliky:", 0, FA_BANK, 18, nil, 20, 100, "%", 20},
  {"Vrtulkovy zisk (znas.):", 0, FA_BANK, 20, nil, 100, 250, nil, 50},
  {"Vrtulkovy zisk:", 0, FA_BANK, 59, nil, -100, 100, "%", -100},
  { nil, 10, FA_BANK },
  {"RYCHLOST ROTACE", LABEL, FA_BANK },
  {"Cyklika:", 0, FA_BANK, 24, nil, 50, 160},
  {"Vrtulka:", 0, FA_BANK, 26, nil, 50, 200},
}

local stabiFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"Funkce:", 1, FA_BANK, 30, nil, { "Vypnuto", "Zachr. (N)", "Zachr. (A)", "Stabi (N)", "Stabi (A)", "Stabi (M)", "Koaxial", "Zachr.(Auto)", "Kanal" }, { 65, 66, 67, 68, 69, 70, 71, 72, 73 } },
  { nil, 10, FA_BANK },
  {"Kolektiv zachrany:", 0, FA_BANK, 34, nil, 0, 100, "%", 0},
  {"Doba trvani zachrany:", 0, FA_BANK, 138, nil, 0, 250},
  {"Kolektiv visu modelu:", 0, FA_BANK, 139, nil, 0, 100, "%", 0},
  {"Priorita kniplu:", 0, FA_BANK, 36, nil, 0, 16},
  {"Mira zmeny smeru:", 0, FA_BANK, 33, nil, 0, 5},
  {"Prodleva Akro:", 0, FA_BANK, 73, nil, 0, 30},
}

local advancedFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 3},
  {"CYKLIKA", LABEL, FA_BANK },
  {"Geometry 6 st.:", 0, 0, 19, nil, 64, 250},
  {"Smer kolektivu (reverz):", 1, 0, 77, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"Vyskovkovy filtr:", 0, FA_BANK, 42, nil, 0, 4},
  {"Pocatecni reakce cykliky:", 0, FA_BANK, 25, nil, 1, 12},
  { nil, 10, FA_BANK },
  {"VRTULKA", LABEL, FA_BANK },
  {"Zpozdeni:", 0, FA_BANK, 43, nil, 0, 30},
  {"Drzeni piruet:", 0, FA_BANK, 37, nil, 130, 250},
  {"Dynamika:", 0, FA_BANK, 29, nil, 3, 10},
  {"Revomix:", 0, FA_BANK, 32, nil, 0, 10, "", -128},
}

local profileFields = {
  {"NASTAVENI", LABEL, FA_BANK },
  {"Ulozit nastaveni", BUTTON, FA_BANK, 160, 0},
  { nil, 10, FA_BANK },
  { nil, 0, FA_BANK + FA_INVIS, 58, nil, 0, 7},
  {"PREPINANI BANK", LABEL, FA_BANK },
  {"Bank", 0, FA_BANK, 3, nil, 0, 2},
}

local function addField(step)
  local field = fields[current]
  local min, max
  if field[2] == 0 then
    min = field[6]
    max = field[7]
  elseif field[2] == 1 then
    min = 0
    max = #(field[6]) - 1
  end
  if field[5] ~= nil then
    if (step < 0 and field[5] > min) or (step > 0 and field[5] < max) then
      field[5] = field[5] + step
    end
  end
end

local function selectPage(step)
  current = 1
  page = 1 + ((page + step - 1 + #pages) % #pages)
  refreshIndex = 0
  pageOffset = 0
end

local function selectField(step)
  if current <= #fields and fields[current][2] == BUTTON then
    fields[current][5] = 0
  end
  
  current = 1 + ((current + step - 1 + #fields) % #fields)
  
  local invisible = bit32.band(fields[current][3], FA_INVIS) ~= 0 

  if current > 7 + pageOffset then
    pageOffset = current - 7
  elseif current <= pageOffset then
    pageOffset = current - 1
  end
  
  if fields[current][2] == 10 or fields[current][2] == LABEL or invisible then
    selectCtr = selectCtr + 1
    
    if selectCtr < 16 then
      selectField (step)
    end
  end
  
  selectCtr = 0
end

local function drawProgressBar()
  local width = (140 * refreshIndex) / #fields
  local width = (140 * refreshIndex) / #fields
  lcd.drawRectangle(48, 1, 144, 6)
  lcd.drawFilledRectangle(50, 3, width, 2)
end

local function redrawFieldsPage()
  lcd.clear()
  
  lcd.drawScreenTitle(pages[page][2], page, #pages)

  if refreshIndex < #fields then
    drawProgressBar()
  end

  local skip = 0
  local index = 0

  while true do
    index = index + 1
    if index - skip > 7 then
      break
    end
    local field = fields[pageOffset+index]
    if field == nil then
      break
    end
    
    local visible = bit32.band(field[3], FA_INVIS) == 0
    if not visible then
      skip = skip + 1
    end

    local attr = current == (pageOffset+index) and ((edit == true and BLINK or 0) + INVERS) or 0
    
    if current == (pageOffset+index) and (field[2] > MENU or not visible) then
      current = current + 1
    end
    
    if field[2] ~= 10 and visible then
      if field[2] == LABEL then
        lcd.drawText(0, 1+8*(index-skip), field[1] .. "                                                                     ", INVERS)
      else
        
        lcd.drawText(0, 1+8*(index-skip), " " .. field[1])
        if field[5] == nil then
          lcd.drawText(150, 1+8*(index-skip), "---", attr)
        else
          if field[2] == 0 then
            local val = field[5]
            if field[4] == 65 then
              val = (val * 100) / 20
              attr = attr + PREC2
            elseif field[4] == 20 then
              attr = attr + PREC2
            elseif field[4] == 24 or field[4] == 26 or field[4] == 73 or field[4] == 138 then
              attr = attr + PREC1
            end
            if field[8] ~= nil then
              lcd.drawText(150 - string.len(val .. field[8]), 1+8*(index-skip), val .. field[8], attr)
            else
              lcd.drawNumber(150 - string.len(val), 1+8*(index-skip), val, LEFT + attr)
            end
          elseif field[2] == 1 then
            if field[5] >= 0 and field[5] < #(field[6]) then
              lcd.drawText(150 - string.len(field[6][1+field[5]]), 1+8*(index-skip), field[6][1+field[5]], attr)
            end
          elseif field[2] == BUTTON or field[2] == MENU then
            local stat = "*"
            if field[5] == 1 then
              stat = "OK"
            end
            lcd.drawText(150 - string.len(stat), 1+8*(index-skip), stat, attr)
          end
        end
      end
    end
  end
  
  if index == (skip+1) then
    lcd.drawText(150/6, 1+8*4, "Zadne parametry. Bank: " .. fields[1][5], 0)
  end
end

local function telemetryRead(field)
  field = field + 0x50
  return sportTelemetryPush(0x1B, 0x30, 0x0C40, field)
end

local function telemetryWrite(field, value)
  field = field + 0x50
  return sportTelemetryPush(0x1B, 0x31, 0x0C40, field + value*256)
end

local function paramHandler(fieldId, value)
  if fieldId == 3 then
    for idx = 1, #fields, 1 do
      if fields[idx][4] ~= 3 and fields[idx][4] ~= 56 and bit32.band(fields[idx][3], FA_BANK) == 0 then
        if value == 0 then
          fields[idx][3] = bit32.band(fields[idx][3], bit32.bnot(FA_INVIS))
        else
          fields[idx][3] = bit32.bor(fields[idx][3], FA_INVIS)
        end
      end
    end
  elseif fieldId == 8 then
    if value ~= 67 and fields[7] ~= nil then
      if fields[7][5] == 6 then
        fields[7][5] = 0
        telemetryWrite(9, 65)
      end
    end
  elseif fieldId == 9 then
    if value == 71 then
      if fields[6][5] ~= 2 then
        fields[7][5] = 0
        modifications[1][2] = 65
      end
    end
  elseif fieldId == 30 then
    if value >= 66 and value <= 67 then
      fields[4][3] = bit32.band(fields[4][3], bit32.bnot(FA_INVIS))
      fields[5][3] = bit32.band(fields[5][3], bit32.bnot(FA_INVIS))
      fields[6][3] = bit32.band(fields[6][3], bit32.bnot(FA_INVIS))
    else
      fields[4][3] = bit32.bor(fields[4][3], FA_INVIS)
      fields[5][3] = bit32.bor(fields[5][3], FA_INVIS)
      fields[6][3] = bit32.bor(fields[6][3], FA_INVIS)
    end
    if value >= 66 and value <= 67 or value == 71 then
      fields[7][3] = bit32.band(fields[7][3], bit32.bnot(FA_INVIS))
    else
      fields[7][3] = bit32.bor(fields[7][3], FA_INVIS)
    end
    if value >= 68 then
      fields[8][3] = bit32.band(fields[8][3], bit32.bnot(FA_INVIS))
    else
      fields[8][3] = bit32.bor(fields[8][3], FA_INVIS)
    end
    if value == 66 then
      fields[9][3] = bit32.band(fields[9][3], bit32.bnot(FA_INVIS))
    else
      fields[9][3] = bit32.bor(fields[9][3], FA_INVIS)
    end
    if value == 73 then
      fields[4][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[5][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[6][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[7][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[8][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[9][3] = bit32.bor(fields[9][3], FA_INVIS)
    end
  elseif fieldId == 58 then
    if value == 7 then
      fields[5][3] = bit32.bor(fields[5][3], FA_INVIS)
      fields[6][3] = bit32.bor(fields[6][3], FA_INVIS)
    else
      fields[5][3] = bit32.band(fields[5][3], bit32.bnot(FA_INVIS))
      fields[6][3] = bit32.band(fields[6][3], bit32.bnot(FA_INVIS))
    end
  elseif fieldId == 56 then
    if value == 7 then
      fields[6][3] = bit32.band(fields[6][3], bit32.bnot(FA_INVIS))
    else
      fields[6][3] = bit32.bor(fields[6][3], FA_INVIS)
    end
  end
end

local telemetryPopTimeout = 0
local function refreshNext()
  if refreshState == 0 then
    if #modifications > 0 then
      if modifications[1][1] == 8 or modifications[1][1] == 9 then
        paramHandler(modifications[1][1], modifications[1][2])
      end
      telemetryWrite(modifications[1][1], modifications[1][2])
      if modifications[1][1] == 30 then
        paramHandler(modifications[1][1], modifications[1][2])
        refreshIndex = 3
      end
      modifications[1] = nil
    elseif refreshIndex < #fields then
      local field = fields[refreshIndex + 1]
      if field[4] ~= nil and field[2] ~= BUTTON and field[2] ~= MENU and bit32.band(field[3], FA_INVIS) == 0 or field[4] == 3 or field[4] == 56 or field[4] == 58 then
        if telemetryRead(field[4]) == true then
          refreshState = 1
          telemetryPopTimeout = getTime() + 80
        end
      else
        refreshIndex = refreshIndex + 1 
      end
    end
  elseif refreshState == 1 then
    local physicalId, primId, dataId, value = sportTelemetryPop()
    if primId == 0x32 and dataId == 0x0C40 then
      local fieldId = (value % 256) - 0x50
      local field = fields[refreshIndex + 1]
      if fieldId == field[4] then
        local value = math.floor(value / 256)
        paramHandler(fieldId, value)
        
        if field[2] == 1 and #field == 7 then
          for index = 1, #(field[7]), 1 do
            if value == field[7][index] then
              value = index - 1
              break
            end
          end
        elseif field[2] == 0 and #field == 9 then
          value = value + field[9]
        end
        fields[refreshIndex + 1][5] = value
        
        refreshIndex = refreshIndex + 1
        refreshState = 0
      end
    elseif getTime() > telemetryPopTimeout then
      refreshState = 0
    end
  end
end

local function updateField(field)
  local value = field[5]
  if field[2] == 1 and #field == 7 then
    value = field[7][1+value]
  elseif field[2] == 0 and #field == 9 then
    value = value - field[9]
  elseif field[2] == BUTTON then
    fields[current][5] = 1
    value = 1
  end
  modifications[#modifications+1] = { field[4], value }
end

local function runFieldsPage(event)
  if event == EVT_EXIT_BREAK then
    telemetryWrite(161, 0)
    return 2
  elseif event == EVT_ENTER_BREAK then
    if fields[current] ~= nil then
      if fields[current][2] == BUTTON then
        if fields[current][5] == 0 then
          updateField(fields[current])
        end
      elseif fields[current][2] == MENU then
        local tmp = pages[page][1]
        local menu = 1+fields[current][5]
        
        pages[page][1] = pages[page][3][menu]
        pages[page][3][menu] = tmp

        selectPage (0)
      elseif fields[current][5] ~= nil then
        edit = not edit
        if edit == false then
          updateField(fields[current])
        end
      end
    end
  elseif edit then
    if event == EVT_PLUS_FIRST or event == EVT_PLUS_REPT or event == EVT_ROT_RIGHT then
      addField(1)
    elseif event == EVT_MINUS_FIRST or event == EVT_MINUS_REPT or event == EVT_ROT_LEFT then
      addField(-1)
    end
  else
    if event == EVT_MINUS_FIRST or event == EVT_ROT_RIGHT then
      selectField(1)
    elseif event == EVT_PLUS_FIRST or event == EVT_ROT_LEFT then
      selectField(-1)
    end
  end
  redrawFieldsPage()
  return 0
end

local function init()
  current, edit, refreshState, refreshIndex = 1, false, 0, 0
  pages = {
    {generalFields, "Obecne"},
    {servosFields, "Serva" },
    {limitsFields, "Limity"},
    {sensorFields, "Senzor"},
    {stabiFields, "Stabi"},
    {advancedFields, "Pokroc."},
    {profileFields, "Profil"},
  }
end

local function run(event)
  if event == nil then
    return 2
  elseif event == EVT_PAGE_BREAK then
    selectPage(1)
  elseif event == EVT_PAGE_LONG then
    killEvents(event);
    selectPage(-1)
  end
  fields = pages[page][1]
  local result = runFieldsPage(event)
  refreshNext()
  return result
end

return { init=init, run=run }
