-- Spirit Aero - Basic Script
-- Copyright (C) 2016 Spirit System, FrSky dev@spirit-system.com
-- This file is distributed under Creative Commons 4 license - BY-NC-ND
-- Script version: 1.0.1

-- VALUE = 0
-- COMBO = 1
local BUTTON = 2
local MENU = 3
-- BLANK = 10
local LABEL = 20

local FA_INVIS = 1
local FA_BANK =  2

local edit = false
local page = 1
local current = 1
local refreshState = 0
local refreshIndex = 0
local pageOffset = 0
local pages = {}
local fields = {}
local modifications = {}
local selectCtr = 0

local generalFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"Model:", 1, 0, 5, nil, { "Plane", "F. Wing" }, { 65, 66} },
  {"Position:", 1, 0, 2, nil, { "Horz(0)", "Horz(180)", "Horz(0+i)", "Horz(180+i)", "Vert(0-l)", "Vert(180-l)", "Vert(0-r)", "Vert(180-r)" }, { 65, 66, 67, 68, 69, 70, 71, 72} },
  {"Receiver Type:", 1, 0, 4, nil, { "PWM", "PPM", "S-BUS" }, { 65, 66, 68 } },
}

local servosFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"Mdl", 0, FA_INVIS, 5, nil, 65, 66 },
  {"Servo Frequency:", 1, 0, 7, nil, { "50Hz", "60Hz", "100Hz", "150Hz", "200Hz", "333Hz" }, { 65, 66, 67, 68, 69, 70 } },
  { nil, 10, 0 },
  {"SUBTRIM", LABEL, 0 },
  {"CH1:", 0, 0, 15, nil, -127, 127, "", -127},
  {"CH2:", 0, 0, 16, nil, -127, 127, "", -127},
  {"CH3:", 0, 0, 17, nil, -127, 127, "", -127},
  {"CH4:", 0, 0, 11, nil, -127, 127, "", -127},
  {"CH0:", 0, 0, 24, nil, -127, 127, "", -127},
  { nil, 10, 0 },
  {"SERVO REVERSE", LABEL, 0 },
  {"CH1: ", 1, 0, 21, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH2: ", 1, 0, 22, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH3: ", 1, 0, 23, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH4: ", 1, 0, 31, nil, { "[ ]", "[x]" }, { 48, 49 } },
  {"CH0: ", 1, 0, 32, nil, { "[ ]", "[x]" }, { 48, 49 } },
}

local limitsFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"Mdl", 0, FA_INVIS, 5, nil, 65, 66 },
  {"AILERON RANGE", LABEL, 0 },
  {"Left:", 0, 0, 10, nil, 32, 255},
  {"Right:", 0, 0, 6, nil, 32, 255},
  { nil, 10, 0 },
  {"ELEVATOR RANGE", LABEL, 0 },
  {"Up:", 0, 0, 8, nil, 32, 255},
  {"Down:", 0, 0, 12, nil, 32, 255},
  { nil, 10, 0 },
  {"RUDDER RANGE", LABEL, 0 },
  {"Left:", 0, 0, 13, nil, 32, 255},
  {"Right:", 0, 0, 9, nil, 32, 255},
}

local sensorFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"", 0, FA_INVIS, 56, nil, 0, 7},
  {"Mdl", 0, FA_INVIS, 5, nil, 65, 66 },
  {"SENSOR GAIN", LABEL, FA_BANK },
  {"Global Gain:", 0, FA_BANK, 59, nil, -100, 100, "%", -100},
  {"Elevator:", 0, FA_BANK, 18, nil, 0, 100, "%", 0},
  {"Aileron:", 0, FA_BANK, 19, nil, 0, 100, "%", 0},
  {"Rudder:", 0, FA_BANK, 20, nil, 0, 100, "%", 0},

}

local stabiFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"Function:", 1, FA_BANK, 30, nil, { "Disabled", "Rescue (N)", "Rescue (A)", "Stabi (N)", "Stabi (A)" }, { 65, 66, 67, 68, 69 } },
  { nil, 10, FA_BANK },
  {"Rescue inclination:", 0, FA_BANK, 34, nil, 0, 10, "%", -127},
  {"Direction Control Rate:", 0, FA_BANK, 33, nil, 0, 5},
}

local advancedFields = {
  {"Bank", 0, FA_INVIS, 3, nil, 0, 2},
  {"Feed Forward:", 0, FA_BANK, 25, nil, 1, 12},
  {"Stick Deadband:", 0, FA_BANK, 28, nil, 4, 30},
  {"Aileron Differential", 0, FA_BANK, 14, nil, 0, 100, "%", -127},
}

local profileFields = {
  {"SETTINGS", LABEL, FA_BANK },
  {"Save Settings", BUTTON, FA_BANK, 100, 0},
  { nil, 10, FA_BANK },
  { nil, 0, FA_BANK + FA_INVIS, 58, nil, 0, 7},
  {"BANK SWITCHING", LABEL, FA_BANK },
  {"Bank", 0, FA_BANK, 3, nil, 0, 2},
}

local function addField(step)
  local field = fields[current]
  local min, max
  if field[2] == 0 then
    min = field[6]
    max = field[7]
  elseif field[2] == 1 then
    min = 0
    max = #(field[6]) - 1
  end
  if field[5] ~= nil then
    if (step < 0 and field[5] > min) or (step > 0 and field[5] < max) then
      field[5] = field[5] + step
    end
  end
end

local function selectPage(step)
  current = 1
  page = 1 + ((page + step - 1 + #pages) % #pages)
  refreshIndex = 0
  pageOffset = 0
end

local function selectField(step)
  if current <= #fields and fields[current][2] == BUTTON then
    fields[current][5] = 0
  end
  
  current = 1 + ((current + step - 1 + #fields) % #fields)
  
  local invisible = bit32.band(fields[current][3], FA_INVIS) ~= 0 

  if current > 10 + pageOffset then
    pageOffset = current - 10
  elseif current <= pageOffset then
    pageOffset = current - 1
  end
  
  if fields[current][2] == 10 or fields[current][2] == LABEL or invisible then
    selectCtr = selectCtr + 1
    
    if selectCtr < 16 then
      selectField (step)
    end
  end
  
  selectCtr = 0
end

local function drawProgressBar()
  local width = (140 * refreshIndex) / #fields
  lcd.drawRectangle(48+128, 11, 144, 6)
  lcd.drawFilledRectangle(50+128, 13, width, 2)
end

local function drawScreenTitle(title,page, pages)
  lcd.drawFilledRectangle(0, 0, LCD_W, 30, TITLE_BGCOLOR)
  lcd.drawText(1, 5, title, MENU_TITLE_COLOR)
  lcd.drawText(LCD_W-40, 5, page.."/"..pages, MENU_TITLE_COLOR)
end

local function redrawFieldsPage()
  lcd.clear()
  lcd.drawFilledRectangle(0, 0, LCD_W, LCD_H, TEXT_BGCOLOR)
  drawScreenTitle(pages[page][2], page, #pages)

  if refreshIndex < #fields then
    drawProgressBar()
  end

  local skip = 0
  local index = 0

  while true do
    index = index + 1
    if index - skip > 10 then
      break
    end
    local field = fields[pageOffset+index]
    if field == nil then
      break
    end
    
    local visible = bit32.band(field[3], FA_INVIS) == 0
    if not visible then
      skip = skip + 1
    end

    local attr = current == (pageOffset+index) and ((edit == true and BLINK or 0) + INVERS) or 0
    
    if current == (pageOffset+index) and (field[2] > MENU or not visible) then
      current = current + 1
    end
    
    if field[2] ~= 10 and visible then
      if field[2] == LABEL then
        lcd.drawText(2, 30+20*(index-skip), field[1] .. "", INVERS)
      else
        lcd.drawText(2, 30+20*(index-skip), " " .. field[1])
        if field[5] == nil then
          lcd.drawText(340, 30+20*(index-skip), "---", attr)
        else
          if field[2] == 0 then
            local val = field[5]
            if field[4] == 65 then
              val = (val * 100) / 20
              attr = attr + PREC2
            elseif field[4] == 73 then
              attr = attr + PREC1
            elseif field[4] == 34 then
              val = val * 10
            end
            if field[8] ~= nil then
              lcd.drawText(340, 30+20*(index-skip), val .. field[8], attr)
            else
              lcd.drawNumber(340, 30+20*(index-skip), val, LEFT + attr)
            end
          elseif field[2] == 1 then
            if field[5] >= 0 and field[5] < #(field[6]) then
              lcd.drawText(340, 30+20*(index-skip), field[6][1+field[5]], attr)
            end
          elseif field[2] == BUTTON or field[2] == MENU then
            local stat = "*"
            if field[5] == 1 then
              stat = "OK"
            end
            lcd.drawText(340, 30+20*(index-skip), stat, attr)
          end
        end
      end
    end
  end
  
  if index == (skip+1) then
    lcd.drawText(340/6, 30+20*4, "No parameter available. Bank: " .. fields[1][5], 0)
  end
end

local function telemetryRead(field)
  field = field + 0x81
  return sportTelemetryPush(0x1B, 0x30, 0x0C50, field)
end

local function telemetryWrite(field, value)
  field = field + 0x81
  return sportTelemetryPush(0x1B, 0x31, 0x0C50, field + value*256)
end

local function paramHandler(fieldId, value)
  if fieldId == 5 and page == 2 and fields[1][5] == 0 then
    if value == 65 then
      fields[7][3] = bit32.band(fields[7][3], bit32.bnot(FA_INVIS))
      fields[9][3] = bit32.band(fields[9][3], bit32.bnot(FA_INVIS))
      fields[10][3] = bit32.band(fields[10][3], bit32.bnot(FA_INVIS))
      fields[14][3] = bit32.band(fields[14][3], bit32.bnot(FA_INVIS))
      fields[16][3] = bit32.band(fields[16][3], bit32.bnot(FA_INVIS))
      fields[17][3] = bit32.band(fields[17][3], bit32.bnot(FA_INVIS))
    else
      fields[7][3] = bit32.bor(fields[7][3], FA_INVIS)
      fields[9][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[10][3] = bit32.bor(fields[10][3], FA_INVIS)
      fields[14][3] = bit32.bor(fields[14][3], FA_INVIS)
      fields[16][3] = bit32.bor(fields[16][3], FA_INVIS)
      fields[17][3] = bit32.bor(fields[17][3], FA_INVIS)
    end
  elseif fieldId == 5 and page == 3 and fields[1][5] == 0 then
    if value == 65 then
      fields[3][3] = bit32.band(fields[3][3], bit32.bnot(FA_INVIS))
      fields[6][3] = bit32.band(fields[6][3], bit32.bnot(FA_INVIS))
      fields[7][3] = bit32.band(fields[7][3], bit32.bnot(FA_INVIS))
      fields[8][3] = bit32.band(fields[8][3], bit32.bnot(FA_INVIS))
      fields[9][3] = bit32.band(fields[9][3], bit32.bnot(FA_INVIS))
      fields[10][3] = bit32.band(fields[10][3], bit32.bnot(FA_INVIS))
      fields[11][3] = bit32.band(fields[11][3], bit32.bnot(FA_INVIS))
      fields[12][3] = bit32.band(fields[12][3], bit32.bnot(FA_INVIS))
      fields[13][3] = bit32.band(fields[13][3], bit32.bnot(FA_INVIS))
    else
      fields[3][3] = bit32.bor(fields[3][3], FA_INVIS)
      fields[6][3] = bit32.bor(fields[6][3], FA_INVIS)
      fields[7][3] = bit32.bor(fields[7][3], FA_INVIS)
      fields[8][3] = bit32.bor(fields[8][3], FA_INVIS)
      fields[9][3] = bit32.bor(fields[9][3], FA_INVIS)
      fields[10][3] = bit32.bor(fields[10][3], FA_INVIS)
      fields[11][3] = bit32.bor(fields[11][3], FA_INVIS)
      fields[12][3] = bit32.bor(fields[12][3], FA_INVIS)
      fields[13][3] = bit32.bor(fields[13][3], FA_INVIS)
    end
  elseif fieldId == 5 and page == 4 then
    if value == 65 then
      fields[8][3] = bit32.band(fields[8][3], bit32.bnot(FA_INVIS))
    else
      fields[8][3] = bit32.bor(fields[8][3], FA_INVIS)
    end
  elseif fieldId == 3 then
    for idx = 1, #fields, 1 do
      if fields[idx][4] ~= 3 and fields[idx][4] ~= 5 and fields[idx][4] ~= 56 and bit32.band(fields[idx][3], FA_BANK) == 0 and page ~= 1 or fields[idx][4] ~= 3 and fields[idx][4] ~= 56 and bit32.band(fields[idx][3], FA_BANK) == 0 and page == 1 then
        if value == 0 then
          fields[idx][3] = bit32.band(fields[idx][3], bit32.bnot(FA_INVIS))
        else
          fields[idx][3] = bit32.bor(fields[idx][3], FA_INVIS)
        end
      end
    end
  elseif fieldId == 8 then
    if value ~= 67 and fields[7] ~= nil then
      if fields[7][5] == 6 then
        fields[7][5] = 0
        telemetryWrite(9, 65)
      end
    end
  elseif fieldId == 9 then
    if value == 71 then
      if fields[6][5] ~= 2 then
        fields[7][5] = 0
        modifications[1][2] = 65
      end
    end
  elseif fieldId == 30 then
    if value >= 66 and value <= 67 then
      fields[4][3] = bit32.band(fields[4][3], bit32.bnot(FA_INVIS))
    else
      fields[4][3] = bit32.bor(fields[4][3], FA_INVIS)
    end
    if value >= 68 then
      fields[5][3] = bit32.band(fields[5][3], bit32.bnot(FA_INVIS))
    else
      fields[5][3] = bit32.bor(fields[5][3], FA_INVIS)
    end
  elseif fieldId == 58 then
    if value == 7 then
      fields[5][3] = bit32.bor(fields[5][3], FA_INVIS)
      fields[6][3] = bit32.bor(fields[6][3], FA_INVIS)
    else
      fields[5][3] = bit32.band(fields[5][3], bit32.bnot(FA_INVIS))
      fields[6][3] = bit32.band(fields[6][3], bit32.bnot(FA_INVIS))
    end
  elseif fieldId == 56 then
    if value == 7 then
      fields[5][3] = bit32.band(fields[5][3], bit32.bnot(FA_INVIS))
    else
      fields[5][3] = bit32.bor(fields[5][3], FA_INVIS)
    end
  end
end

local telemetryPopTimeout = 0
local function refreshNext()
  if refreshState == 0 then
    if #modifications > 0 then
      if modifications[1][1] == 8 or modifications[1][1] == 9 then
        paramHandler(modifications[1][1], modifications[1][2])
      end
      telemetryWrite(modifications[1][1], modifications[1][2])
      if modifications[1][1] == 30 then
        paramHandler(modifications[1][1], modifications[1][2])
        refreshIndex = 3
      end
      modifications[1] = nil
    elseif refreshIndex < #fields then
      local field = fields[refreshIndex + 1]
      if field[4] ~= nil and field[2] ~= BUTTON and field[2] ~= MENU and bit32.band(field[3], FA_INVIS) == 0 or field[4] == 3 or field[4] == 56 or field[4] == 58 or field[4] == 5 then
        if telemetryRead(field[4]) == true then
          refreshState = 1
          telemetryPopTimeout = getTime() + 80
        end
      else
        refreshIndex = refreshIndex + 1 
      end
    end
  elseif refreshState == 1 then
    local physicalId, primId, dataId, value = sportTelemetryPop()
    if physicalId == 0x1A and primId == 0x32 and dataId == 0x0C50 then
      local fieldId = (value % 256) - 0x81
      local field = fields[refreshIndex + 1]
      if fieldId == field[4] then
        local value = math.floor(value / 256)
        paramHandler(fieldId, value)
        
        if field[2] == 1 and #field == 7 then
          for index = 1, #(field[7]), 1 do
            if value == field[7][index] then
              value = index - 1
              break
            end
          end
        elseif field[2] == 0 and #field == 9 then
          value = value + field[9]
        end
        fields[refreshIndex + 1][5] = value
        
        refreshIndex = refreshIndex + 1
        refreshState = 0
      end
    elseif getTime() > telemetryPopTimeout then
      refreshState = 0
    end
  end
end

local function updateField(field)
  local value = field[5]
  if field[2] == 1 and #field == 7 then
    value = field[7][1+value]
  elseif field[2] == 0 and #field == 9 then
    value = value - field[9]
  elseif field[2] == BUTTON then
    fields[current][5] = 1
    value = 1
  end
  modifications[#modifications+1] = { field[4], value }
end

local function runFieldsPage(event)
  if event == EVT_EXIT_BREAK then
    telemetryWrite(101, 0)
    return 2
  elseif event == EVT_ENTER_BREAK then
    if fields[current] ~= nil then
      if fields[current][2] == BUTTON then
        if fields[current][5] == 0 then
          updateField(fields[current])
        end
      elseif fields[current][2] == MENU then
        local tmp = pages[page][1]
        local menu = 1+fields[current][5]
        
        pages[page][1] = pages[page][3][menu]
        pages[page][3][menu] = tmp

        selectPage (0)
      elseif fields[current][5] ~= nil then
        edit = not edit
        if edit == false then
          updateField(fields[current])
        end
      end
    end
  elseif edit then
    if event == EVT_PLUS_FIRST or event == EVT_PLUS_REPT or event == EVT_ROT_RIGHT then
      addField(1)
    elseif event == EVT_MINUS_FIRST or event == EVT_MINUS_REPT or event == EVT_ROT_LEFT then
      addField(-1)
    end
  else
    if event == EVT_MINUS_FIRST or event == EVT_ROT_RIGHT then
      selectField(1)
    elseif event == EVT_PLUS_FIRST or event == EVT_ROT_LEFT then
      selectField(-1)
    end
  end
  redrawFieldsPage()
  return 0
end

local function init()
  current, edit, refreshState, refreshIndex = 1, false, 0, 0
  pages = {
    {generalFields, "General"},
    {servosFields, "Servos" },
    {limitsFields, "Limits"},
    {sensorFields, "Sensor"},
    {stabiFields, "Stabi"},
    {advancedFields, "Advanced"},
    {profileFields, "Profile"},
  }
end

local function run(event)
  if event == nil then
    return 2
  elseif event == EVT_PAGE_BREAK or event == EVT_PAGEDN_FIRST then
    selectPage(1)
  elseif event == EVT_PAGE_LONG or event == EVT_PAGEUP_FIRST then
    killEvents(event);
    selectPage(-1)
  end
  fields = pages[page][1]
  local result = runFieldsPage(event)
  refreshNext()
  return result
end

return { init=init, run=run }
