-- Spirit Settings - LogViewer Script
-- Copyright (C) 2017 Spirit System, FrSky dev@spirit-system.com
-- This file is distributed under Creative Commons 4 license - BY-NC-ND
-- Script version: 2.4.4

-- VALUE = 0
-- COMBO = 1
local BUTTON = 2
local MENU = 3
-- BLANK = 10
local LABEL = 20

local FA_INVIS = 1
local FA_BANK =  2

local edit = false
local page = 1
local current = 1
local refreshState = 0
local refreshIndex = 0
local pageOffset = 0
local pages = {}
local fields = {}
local modifications = {}
local selectCtr = 0
local value_tmp = 7
local chan_col = false
local logcnt = 0
local logcntp = 0

local diagFields = {
  {"Duration", 0, 0, 111, nil, 0, 255, "s", 0},
  {"Flight: ", 1, 0, 112, nil, { "Current", "Previous" }, { 0, 1 } },
  { nil, 10, 0 },
}

local function addField(step)
  local field = fields[current]
  local min, max
  if field[2] == 0 then
    min = field[6]
    max = field[7]
  elseif field[2] == 1 then
    min = 0
    max = #(field[6]) - 1
  end
  if (step < 0 and field[5] > min) or (step > 0 and field[5] < max) then
    field[5] = field[5] + step
  end
end

local function selectPage(step)
  current = 1
  page = 1 + ((page + step - 1 + #pages) % #pages)
  refreshIndex = 0
  pageOffset = 0
end

local function selectField(step)
  if current <= #fields and fields[current][2] == BUTTON then
    fields[current][5] = 0
  end
  
  current = 1 + ((current + step - 1 + #fields) % #fields)
  
  local invisible = bit32.band(fields[current][3], FA_INVIS) ~= 0 

  if current > 7 + pageOffset then
    pageOffset = current - 7
  elseif current <= pageOffset then
    pageOffset = current - 1
  end
  
  if fields[current][2] == 10 or fields[current][2] == LABEL or invisible then
    selectCtr = selectCtr + 1
    
    if selectCtr < 16 then
      selectField (step)
    end
  end

  value_tmp = fields[current][5]
  
  selectCtr = 0
end

local function drawProgressBar()
  local width = (140 * refreshIndex) / #fields
  local width = (140 * refreshIndex) / #fields
  lcd.drawRectangle(48, 1, 144, 6)
  lcd.drawFilledRectangle(50, 3, width, 2)
end

local function redrawFieldsPage()
  lcd.clear()
  
  lcd.drawScreenTitle(pages[page][2], page, #pages)

  if refreshIndex < #fields then
    drawProgressBar()
  end

  local skip = 0
  local index = 0

  while true do
    index = index + 1
    if index - skip > 7 then
      break
    end
    local field = fields[pageOffset+index]
    if field == nil then
      break
    end
    
    local visible = bit32.band(field[3], FA_INVIS) == 0
    if not visible then
      skip = skip + 1
    end

    local attr = current == (pageOffset+index) and ((edit == true and BLINK or 0) + INVERS) or 0
    
    if current == (pageOffset+index) and (field[2] > MENU or not visible) then
      current = current + 1
    end
    
    if field[2] ~= 10 and visible then
      if field[2] == LABEL then
        lcd.drawText(0, 1+8*(index-skip), field[1] .. "                                                                     ", INVERS)
      else
        
        if field[4] == 113 and field[5] ~= nil then
          local LOG_EVENT_OK = 0x0
          local LOG_EVENT_GOVSENSOR = 0x1
          local LOG_EVENT_CYCRING = 0x2
          local LOG_EVENT_RUDLIM = 0x4
          local LOG_EVENT_VIBES = 0x8
          local LOG_EVENT_HANG = 0x10
          local LOG_EVENT_RXLOSS = 0x20
          local LOG_EVENT_LOWVOLT = 0x40
          local LOG_EVENT_GOVENGAGED = 0x80
          local LOG_EVENT_RXCORRUPT = 0x100
          local LOG_EVENT_GOVSIGNAL = 0x200
          local LOG_EVENT_GOVLOST = 0x400

          local log_message = { "Good Health Message",
            "Governor RPM out of range",
            "Cyclic Ring Activated",
            "Rudder Limit Reached",
            "Vibration Level is very high",
            "Main Loop Hang Occured",
            "Receiver Signal Lost",
            "Power Voltage is low",
            "Governor was Engaged",
            "Calibration Finished",
            "Received Frame was Corrupted",
            "RPM Sensor data are too noisy",
            "RPM Sensor data are lost",
            "Data are not available" }

          local msg = {}
          if bit32.band(field[5], LOG_EVENT_GOVSENSOR) > 0 then
              msg[#msg+1] = log_message[2]
          end
          if bit32.band(field[5], LOG_EVENT_CYCRING) > 0 then
              msg[#msg+1] = log_message[3]
          end
          if bit32.band(field[5], LOG_EVENT_RUDLIM) > 0 then
              msg[#msg+1] = log_message[4]
          end
          if bit32.band(field[5], LOG_EVENT_VIBES) > 0 then
              msg[#msg+1] = log_message[5]
          end
          if bit32.band(field[5], LOG_EVENT_HANG) > 0 then
              msg[#msg+1] = log_message[6]
          end
          if bit32.band(field[5], LOG_EVENT_RXLOSS) > 0 then
              msg[#msg+1] = log_message[7]
          end
          if bit32.band(field[5], LOG_EVENT_LOWVOLT) > 0 then
              msg[#msg+1] = log_message[8]
          end
          if bit32.band(field[5], LOG_EVENT_GOVENGAGED) > 0 then
              msg[#msg+1] = log_message[9]
          end
          if bit32.band(field[5], LOG_EVENT_RXCORRUPT) > 0 then
              msg[#msg+1] = log_message[11]
          end
          if bit32.band(field[5], LOG_EVENT_GOVSIGNAL) > 0 then
              msg[#msg+1] = log_message[12]
          end
          if bit32.band(field[5], LOG_EVENT_GOVLOST) > 0 then
              msg[#msg+1] = log_message[13]
          end  
  
          if field[5] == 0 then
            if ((pageOffset+index)-3) == 0 then
              msg[#msg+1] = log_message[10]
            else
              msg[#msg+1] = log_message[1]
            end
          elseif field[5] == 0xffff then
            msg[#msg+1] = log_message[14]
          end
          
          local msgctr = (math.floor(getTime() / 150) % #msg) + 1

          local msgapp = ""
          if #msg > 1 then
            msgapp = ", ..."
          end

          lcd.drawText(0, 1+8*(index-skip), ((pageOffset+index)-3) .. "0s " .. msg[msgctr] .. msgapp, attr)
        else
           lcd.drawText(0, 1+8*(index-skip), " " .. field[1])
        end
        if field[5] == nil then
          lcd.drawText(150, 1+8*(index-skip), "---", attr)
        else
          if field[2] == 0 then
            local val = field[5]
            if field[4] == 65 then
              val = (val * 100) / 20
              attr = attr + PREC2
            elseif field[4] == 20 then
              attr = attr + PREC2
            elseif field[4] == 73 then
              attr = attr + PREC1
            elseif field[4] == 111 then
              val = val * 10
            end
            if field[8] ~= nil then
              lcd.drawText(150, 1+8*(index-skip), val .. field[8], attr)
            else
              if field[4] ~= 113 then
                lcd.drawNumber(150, 1+8*(index-skip), val, LEFT + attr)
              end
            end
          elseif field[2] == 1 then
            if field[5] >= 0 and field[5] < #(field[6]) then
              lcd.drawText(150, 1+8*(index-skip), field[6][1+field[5]], attr)
            end
          elseif field[2] == BUTTON or field[2] == MENU then
            local stat = "*"
            if field[5] == 1 then
              stat = "OK"
            end
            lcd.drawText(150, 1+8*(index-skip), stat, attr)
          end
        end
      end
    end
  end
  
  if index == (skip+1) then
    lcd.drawText(150/6, 1+8*4, "No parameter available. Bank: " .. fields[1][5], 0)
  end
end

local function telemetryRead(field)
  field = field + 0x81
  return sportTelemetryPush(0x1B, 0x30, 0x0C40, field)
end

local function telemetryWrite(field, value)
  field = field + 0x81
  return sportTelemetryPush(0x1B, 0x31, 0x0C40, field + value*256)
end

local function paramHandler(fieldId, value)
  if fieldId == 111 then
    logcnt = value
  elseif fieldId >= 112 then
    if logcntp < logcnt then      
      local test = {"N/A", 0, 0, 113, nil, 0, 255}
      fields[#fields+1] = test
      logcntp = logcntp + 1
    end
  end
end

local telemetryPopTimeout = 0
local function refreshNext()
  if refreshState == 0 then
    if #modifications > 0 then
      telemetryWrite(modifications[1][1], modifications[1][2])
      modifications[1] = nil
    elseif refreshIndex < #fields then
      local field = fields[refreshIndex + 1]
      if field[4] ~= nil and field[2] ~= BUTTON and field[2] ~= MENU and bit32.band(field[3], FA_INVIS) == 0 or field[4] == 3 or field[4] == 4 or field[4] == 52 or field[4] == 53 or field[4] == 54 or field[4] == 55 or field[4] == 56 or field[4] == 57 or field[4] == 58 then
        if telemetryRead(field[4]) == true then
          refreshState = 1
          telemetryPopTimeout = getTime() + 80
        end
      else
        refreshIndex = refreshIndex + 1 
      end
    end
  elseif refreshState == 1 then
    local physicalId, primId, dataId, value = sportTelemetryPop()
    if physicalId == 0x1A and primId == 0x32 and dataId == 0x0C40 then
      local fieldId = (value % 256) - 0x81
      local field = fields[refreshIndex + 1]
      if fieldId == field[4] then
        local value = math.floor(value / 256)
        paramHandler(fieldId, value)
        
        if field[2] == 1 and #field == 7 then
          for index = 1, #(field[7]), 1 do
            if value == field[7][index] then
              value = index - 1
              break
            end
          end
        elseif field[2] == 0 and #field == 9 then
          value = value + field[9]
        end
        fields[refreshIndex + 1][5] = value
        
        refreshIndex = refreshIndex + 1
        refreshState = 0
      end
    elseif getTime() > telemetryPopTimeout then
      refreshState = 0
    end
  end
end

local function updateField(field)
  local value = field[5]
  if field[2] == 1 and #field == 7 then
    value = field[7][1+value]
  elseif field[2] == 0 and #field == 9 then
    value = value - field[9]
  elseif field[2] == BUTTON then
    fields[current][5] = 1
    value = 1
  end
  modifications[#modifications+1] = { field[4], value }
end

local function runFieldsPage(event)
  if event == EVT_EXIT_BREAK then
    telemetryWrite(101, 0)
    return 2
  elseif event == EVT_ENTER_BREAK then
    if fields[current] ~= nil then
      if fields[current][2] == BUTTON then
        if fields[current][5] == 0 then
          updateField(fields[current])
        end
      elseif fields[current][2] == MENU then
        local tmp = pages[page][1]
        local menu = 1+fields[current][5]
        
        pages[page][1] = pages[page][3][menu]
        pages[page][3][menu] = tmp

        selectPage (0)
      end
    end
  elseif edit then
    if event == EVT_PLUS_FIRST or event == EVT_PLUS_REPT or event == EVT_ROT_RIGHT then
      addField(1)
    elseif event == EVT_MINUS_FIRST or event == EVT_MINUS_REPT or event == EVT_ROT_LEFT then
      addField(-1)
    end
  else
    if event == EVT_MINUS_FIRST or event == EVT_ROT_RIGHT then
      selectField(1)
    elseif event == EVT_PLUS_FIRST or event == EVT_ROT_LEFT then
      selectField(-1)
    end
  end
  redrawFieldsPage()
  return 0
end

local function init()
  current, edit, refreshState, refreshIndex = 1, false, 0, 0
  pages = {
    {diagFields, "Log"},
  }
end

local function run(event)
  if event == nil then
    return 2
  end
  fields = pages[page][1]
  local result = runFieldsPage(event)
  refreshNext()
  return result
end

return { init=init, run=run }
